<?php

function lands_blog_styles() {
//    wp_enqueue_style('lands_blog_style_bootstrapjs', get_template_directory_uri() . '/assets/css/bootstrap.min.js', NULL, NULL, 'all');
//    wp_enqueue_style('lands_blog_style_bootstrapcss', get_template_directory_uri() . '/assets/css/bootstrap.min.css', NULL, NULL, 'all');
//    wp_enqueue_style('lands_blog_style_reset', get_template_directory_uri() . '/assets/css/reset.css', NULL, NULL, 'all');
//    wp_enqueue_style('lands_site_style', get_template_directory_uri() . '/assets/css/lands_site.css', NULL, NULL, 'all');
    wp_enqueue_style('lands_blog_style', get_template_directory_uri() . '/assets/css/lands.css', NULL, NULL, 'all');
}

add_action('wp_enqueue_scripts', 'lands_blog_styles');

function lands_blog_scripts() {
//    wp_register_script('lands_blog_script_jquery', get_template_directory_uri() . '/assets/js/jquery-3.2.1.min.js', array('jquery'), '3.2.1', true);
//    wp_enqueue_script('lands_blog_script_jquery');
//    wp_register_script('lands_blog_script_bootstrap', get_template_directory_uri() . '/assets/js/bootstrap.min.js');
//    wp_enqueue_script('lands_blog_script_bootstrap');
}

add_action('wp_enqueue_scripts', 'lands_blog_scripts');

function lands_blog_fonts() {
    wp_enqueue_style('lands_blog_font_exo', 'https://fonts.googleapis.com/css?family=Exo:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i', NULL, NULL, 'all');
}

add_action('wp_enqueue_scripts', 'lands_blog_fonts');

if (function_exists('register_sidebar')) {
    register_sidebar(array(
        'name' => 'Sidebar',
        'before_widget' => '<div class="widget">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>',
    ));
}

if (is_user_logged_in()) {
    show_admin_bar(false);
}

function catch_first_image() {
    global $post, $posts;
    $first_img = '';
    ob_start();
    ob_end_clean();
    $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
    $first_img = $matches [1] [0];
    return $first_img;
}

//function getTheFirstImage() { // http://stackoverflow.com/a/17353713
//    $files = get_children('post_parent='.get_the_ID().'&post_type=attachment&post_mime_type=image');
//    if($files) {
//        $keys = array_reverse(array_keys($files));
//        $num = $keys[0];
//        /*$image = wp_get_attachment_image($num, 'large', false);
//        $imagePieces = explode('"', $image);
//        $imagePath = $imagePieces[0];
//        $thumb = wp_get_attachment_thumb_url($num);
//        echo "<img src=\"$thumb\" />";*/
//        $image = wp_get_attachment_image_src($num, 'medium');
//        return $image[0];
//    }
//    return false;
//}

function numeric_posts_nav() { // http://www.wpbeginner.com/wp-themes/how-to-add-numeric-pagination-in-your-wordpress-theme/
    if (is_singular())
        return;

    global $wp_query;

    /** Stop execution if there's only 1 page */
    if ($wp_query->max_num_pages <= 1)
        return;

    $paged = get_query_var('paged') ? absint(get_query_var('paged')) : 1;
    $max = intval($wp_query->max_num_pages);

    /** 	Add current page to the array */
    if ($paged >= 1)
        $links[] = $paged;

    /** 	Add the pages around the current page to the array */
    if ($paged >= 3) {
        $links[] = $paged - 1;
        $links[] = $paged - 2;
    }

    if (( $paged + 2 ) <= $max) {
        $links[] = $paged + 2;
        $links[] = $paged + 1;
    }

    echo '<div class="navigation"><ul>' . "\n";

    /** 	Previous Post Link */
    if (get_previous_posts_link())
//        printf('<li>%s</li>' . "\n", get_previous_posts_link());
        printf('<li>%s</li>' . "\n", get_previous_posts_link('&lsaquo; Página anterior'));

    /** 	Link to first page, plus ellipses if necessary */
    if (!in_array(1, $links)) {
        $class = 1 == $paged ? ' class="active"' : '';

        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link(1)), '1');

        if (!in_array(2, $links))
            echo '<li>…&nbsp;</li>';
    }

    /** 	Link to current page, plus 2 pages in either direction if necessary */
    sort($links);
    foreach ((array) $links as $link) {
        $class = $paged == $link ? ' class="active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($link)), $link);
    }

    /** 	Link to last page, plus ellipses if necessary */
    if (!in_array($max, $links)) {
        if (!in_array($max - 1, $links))
            echo '<li>…&nbsp;</li>' . "\n";

        $class = $paged == $max ? ' class="active"' : '';
        printf('<li%s><a href="%s">%s</a></li>' . "\n", $class, esc_url(get_pagenum_link($max)), $max);
    }

    /** 	Next Post Link */
    if (get_next_posts_link())
//        printf('<li>%s</li>' . "\n", get_next_posts_link());
        printf('<li>%s</li>' . "\n", get_next_posts_link('Próxima página &rsaquo;'));

    echo '</ul></div>' . "\n";
}

//Register tag cloud filter callback
add_filter('widget_tag_cloud_args', 'tag_widget_limit');

//Limit number of tags inside widget
function tag_widget_limit($args) {

    //Check if taxonomy option inside widget is set to tags
    if (isset($args['taxonomy']) && $args['taxonomy'] == 'post_tag') {
        $args['number'] = 15; //Limit number of tags
    }

    return $args;
}

?>